<?php
/**********************************************************
* Source Copyright 2014 Author                            *
* Unauthorized reproduction is not allowed                *
* Author: JPK Software Solutions Pvt. Ltd.                *
* Email: sales@visionhelpdesk.com                         *
* Owner: www.visionhelpdesk.com                           *
**********************************************************/
if(!defined('_VIS_')) die('Error: Call from undefined function');
class remoteaccess {
    var $error;
	
	function gotomeeting($operation){
		global $vis_language;
		$database=new class_database();
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		$object=new class_setting($database);
		
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'remoteaccess.php');
		$remoteaccess_object=new class_remoteaccess($database);
		
		if(isset($operation['vis_filter_enable']) && $operation['vis_filter_enable']==1){
			$data= isset($operation['vis_action']) && $operation['vis_action']!='' ? parse_form_array($operation['vis_action']) : $operation;             
		    $operation['vis_domain']=$data['vis_domain_filter'];
		   
		 }
		$vis_all_domain=1;
		$filter='integration_type=23 AND is_enabled=1 and domain_id=0';//if all domain selected in setting page
		list($gotomeeting_info, $gotomeeting_details)=$object->get_integration_setting($filter, VIS_STAFF_ID, VIS_LOCATION_AREA,'order by domain_id asc');
		if(!isset($operation['vis_domain'])){
			if($gotomeeting_details==-1){  //if all domain is not selected in setting page
				$vis_all_domain=0;
				$filter='integration_type=23 AND is_enabled=1';
				list($gotomeeting_info, $gotomeeting_details)=$object->get_integration_setting($filter, VIS_STAFF_ID, VIS_LOCATION_AREA,'order by domain_id asc');
			}
		}else{
			if($gotomeeting_details==-1){
				$vis_all_domain=0;
				$filter='integration_type=23 AND domain_id='.$operation['vis_domain'];
				list($gotomeeting_info, $gotomeeting_details)=$object->get_integration_setting($filter, VIS_STAFF_ID, VIS_LOCATION_AREA,'order by domain_id asc');
			}
		}
		
		$page = (isset($operation['vis_page']) && is_numeric($operation['vis_page'])) ? SECURITY_DATA_PER_PAGE*$operation['vis_page']:0;
		$limit = $page+SECURITY_DATA_PER_PAGE;
		$gotomeeting_details=$gotomeeting_details[0];
		$vis_domain = $gotomeeting_details['domain_id'];
		
		$filter1='integration_type=23 AND is_enabled=1';
		list($goto_info, $gotomeeting_setting)=$object->get_integration_setting($filter1, VIS_STAFF_ID, VIS_LOCATION_AREA, 'order by domain_id asc');
	    list($dpinf, $department)=$object->get_domain(VIS_TABLE_PREFIX.'domain.is_enabled=1', '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
	    
	    try {
			$response = $remoteaccess_object->get_access_token($vis_domain, '23');
			if($response->error || $response->int_err_code){
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$response->error.$response->int_err_code.'");</script>';
			}
			else{
				if(isset($data['from_date']) || isset($data['to_date']) || isset($data['vis_search_type'])){
					$goto_meetings = $remoteaccess_object->get_meetings($response->access_token, $operation['vis_domain'], $gotomeeting_details ,$data);
				}
				else{
					$goto_meetings = $remoteaccess_object->get_meetings($response->access_token, $vis_domain, $gotomeeting_details, '');
				}
				$total_meeting=ceil(count($goto_meetings)/SECURITY_DATA_PER_PAGE);
			}
			$all_meeting = count($goto_meetings);
		}
		catch (Exception $e) {
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGACCSSDND'].'");</script>';
			return false;
		}
		
		if((isset($operation['vis_filter_enable']) && $operation['vis_filter_enable']==1)){
			ob_start();
			include(VIS_PATH_TEMPLATE.'gotomeeting_list.php');
			$gotomeeting_list = ob_get_clean();
			ob_end_flush();			
			$select='';
			$select .= "<div class=\"pull-right\">";
			$select .= "<select name=\"pageing\" id=\"paging\" class=\"form-control input-sm selectpicker pull-right paging v-middle\"  onchange=\"javascript:vis_gotomeeting_filter(this.value);\">";					  
			for($i=0;$i<$total_meeting;$i++)
				$select.='<option value="'.$i.'" '.(($page/SECURITY_DATA_PER_PAGE==$i)?'selected="selected"':'').'>'.($i+1).'</option>';
			$select .= "</select><div class=\"text-muted pull-right label_page\">".$vis_language['TXTPAGE'].":</div>";
			$select .='<script>$(".selectpicker").selectpicker();</script>';
			echo json_encode( array('total_cnt' => $all_meeting,'paging' => $select, 'list'=> $gotomeeting_list));
		}else{
			if((isset($operation['vis_domain']) || isset($operation['vis_filter_enable'])) && isset($operation['vis_page']))
				include(VIS_PATH_TEMPLATE.'gotomeeting_list.php');
			else{
				if(isset($operation['vis_domain']))$vis_domain = $operation['vis_domain'];
				include(VIS_PATH_TEMPLATE.'gotomeeting.php');
			}
							
			return true;
		}
	}
	function gotomeeting_details($operation){
        global $vis_language;
        
        $database=new class_database();
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'remoteaccess.php');
		$remoteaccess_object=new class_remoteaccess($database);
		$vis_domain = $operation['vis_chk_domain'];
		$vis_meeting = $operation['vis_meeting_id'];
		
		if(isset($vis_domain) && $vis_domain!='' && is_numeric($vis_domain) && isset($vis_meeting) && $vis_meeting!='' && is_numeric($vis_meeting)) {
			$filter='integration_type=23 AND domain_id='.$vis_domain;
			$access_details = $remoteaccess_object->get_access_token($vis_domain, '23');
			if($access_details->access_token){
				$goto_meetings = $remoteaccess_object->get_meeting_details($access_details->access_token, $vis_meeting, $vis_domain);
				
				if($goto_meetings[0]->subject){
					include(VIS_PATH_TEMPLATE.'gotomeeting_details.php');
					return true;
				}else{
					$this->error=$vis_language['MSGINFOMISS'];
					return false;
				}
			}
			else{
				$this->error=$vis_language['MSGINFOMISS'];
				return false;
			}
        }
        else {
            $this->error=$vis_language['MSGINFOMISS'];
            return false;
        }
    }
   
    function new_gotomeeting($operation){
		global $vis_language;
		$database=new class_database();
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		$object=new class_setting($database);
		
		$database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
        $staff_object=new class_staff($database);
        
        $filter1='integration_type=23 AND is_enabled=1 and domain_id=0';
		list($goto_info, $gotomeeting_details)=$object->get_integration_setting($filter1, VIS_STAFF_ID, VIS_LOCATION_AREA, 'order by domain_id asc');
		if($gotomeeting_details==-1){
			$filter1='integration_type=23 AND is_enabled=1';
			list($goto_info, $gotomeeting_details)=$object->get_integration_setting($filter1, VIS_STAFF_ID, VIS_LOCATION_AREA, 'order by domain_id asc');
		}
		
		list($dpinf, $department)=$object->get_domain(VIS_TABLE_PREFIX.'domain.is_enabled=1', '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
		include(VIS_PATH_TEMPLATE.'gotomeeting_new.php');
		return true;
	}
	function create_meeting($operation){
		
		global $vis_language;
		$database=new class_database();
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'remoteaccess.php');
		$remoteaccess_object=new class_remoteaccess($database);
		if(isset($operation['vis_action'])) $data=parse_form_array($operation['vis_action']);
        else $data=$operation;
		
        $response = $remoteaccess_object->get_access_token($data['vis_domain'], '23');
		if($response->error || $response->int_err_code){
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$response->error.$response->int_err_code.'");</script>';
			return false;
		}
		else{
			
			$url = "https://api.citrixonline.com/G2M/rest/meetings";
			if($data['vis_conf_call']=='text'){$data['vis_conf_call']=$data['vis_enter_text'];}
			$headers = array ("Accept: application/json", "Content-Type: application/json", "Authorization: OAuth oauth_token=".$response->access_token);
			$data_json =  '{"subject":"'.$data['vis_subject'].'",
							"starttime":"'.date('Y-m-d\Th:i:s', strtotime($data['vis_startdate'])).'",
							"endtime":"'.date('Y-m-d\Th:i:s', strtotime($data['vis_enddate'])).'",
							"passwordrequired":"false",
							"conferencecallinfo":"'.$data['vis_conf_call'].'",
							"timezonekey":"",
							"meetingtype":"'.$data['vis_meeting_type'].'"}';
			$ch = curl_init();
			curl_setopt_array ($ch, array ( CURLOPT_URL => $url,CURLOPT_HEADER => false, CURLOPT_FOLLOWLOCATION => false, 
											CURLOPT_RETURNTRANSFER => true, CURLOPT_TIMEOUT => 10,CURLOPT_HTTPHEADER => $headers,
											CURLOPT_POST => true,CURLOPT_POSTFIELDS => $data_json,));
			$results = curl_exec ($ch);
			curl_close ($ch);
			if(trim($results)=='Invalid request body'){
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$results.'");</script>';
				return flase;
			}else{
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'");$("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTGOTOMEETINGS'].'",{"vis_module":"remoteaccess", "vis_operation":"gotomeeting"}); </script>';
				return true;
			}
        }
	}
	
	function get_meeting_delete($operation) {
        global $vis_language;
        $message_info['vis_form_title']=$vis_language['TXTDELETEGOTOMEETING'];
        $message_info['vis_message']=$vis_language['MSGSURE'];
        $message_info['vis_event']="$('#vis_global_msg_div').visExecution('load_operations', {'vis_module':'remoteaccess', 'vis_operation':'delete_meeting', 'vis_domain':'".$operation['vis_domain']."', 'vis_meeting_id':'".$operation['vis_meeting_id']."'})";
        include(VIS_PATH_TEMPLATE.'confirm_delete.php');
        return true;
    }
	
	function delete_meeting($operation){
		global $vis_language;
		$database=new class_database();
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'remoteaccess.php');
		$remoteaccess_object=new class_remoteaccess($database);
		
		$response  = $remoteaccess_object->get_access_token($operation['vis_domain'], '23');
		if($response->error || $response->int_err_code){
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$response->error.$response->int_err_code.'");</script>';
			return false;
		}
		else{
			$intgration_filter='integration_type=23 AND domain_id='.$operation['vis_domain'];
			$database=new class_database();
			include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
			$object=new class_setting($database);
			list($gotomeeting_info, $gotomeeting_details)=$object->get_integration_setting($intgration_filter, VIS_STAFF_ID, VIS_LOCATION_AREA, 'order by domain_id asc');
	
			$ch1 = curl_init();
			curl_setopt($ch1, CURLOPT_URL, $gotomeeting_details[0]['billing_url']."/G2M/rest/meetings/".$operation['vis_meeting_id']);
			$headers = array ("Accept: application/json","Content-Type: application/json","Authorization: OAuth oauth_token=".$response->access_token);
			curl_setopt($ch1, CURLOPT_HTTPHEADER, $headers);
			curl_setopt($ch1, CURLOPT_CUSTOMREQUEST, "DELETE");
			curl_setopt($ch1, CURLOPT_RETURNTRANSFER, true);   
			$goto_meetings = curl_exec($ch1);
			curl_close($ch1);
		}
		echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_gotomeeting_list").visExecution("load_area",{"vis_module":"remoteaccess", "vis_operation":"gotomeeting", "vis_domain":'.$operation['vis_domain'].'}); </script>';
		return true;
	}
		
	function gotoassist($operation){
		global $vis_language;
		$database=new class_database();
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		$object=new class_setting($database);
		
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'remoteaccess.php');
		$remoteaccess_object=new class_remoteaccess($database);
		
		if(isset($operation['vis_filter_enable']) && $operation['vis_filter_enable']==1)
        {
			$data= isset($operation['vis_action']) && $operation['vis_action']!='' ? parse_form_array($operation['vis_action']) : $operation;             
		   $operation['vis_domain']=$data['vis_domain_filter'];
		 }
		$vis_all_domain=1;
		$filter='integration_type=24 AND is_enabled=1 and domain_id=0';//if all domain selected in setting page
		list($gotoassist_info, $gotoassist_details)=$object->get_integration_setting($filter, VIS_STAFF_ID, VIS_LOCATION_AREA,'order by domain_id asc');
		if(!isset($operation['vis_domain'])){
			
			if($gotoassist_details==-1){  //if all domain is not selected in setting page
				$vis_all_domain=0;
				$filter='integration_type=24 AND is_enabled=1';
				list($gotoassist_info, $gotoassist_details)=$object->get_integration_setting($filter, VIS_STAFF_ID, VIS_LOCATION_AREA,'order by domain_id asc');
			}
		}else{
			if($gotoassist_details==-1){
				$filter='integration_type=24 AND is_enabled=1 AND domain_id='.$operation['vis_domain'];
				list($gotoassist_info, $gotoassist_details)=$object->get_integration_setting($filter, VIS_STAFF_ID, VIS_LOCATION_AREA,'order by domain_id asc');
			}
		}
		
		$limit = SECURITY_DATA_PER_PAGE;
		$page = (isset($operation['vis_page']) && is_numeric($operation['vis_page'])) ? $limit*$operation['vis_page']:0;
		
		$gotoassist_details=$gotoassist_details[0];
		$vis_domain = $gotoassist_details['domain_id'];
		
		$filter1='integration_type=24 AND is_enabled=1';
		list($goto_info, $gotoassist_setting)=$object->get_integration_setting($filter1, VIS_STAFF_ID, VIS_LOCATION_AREA, 'order by domain_id asc');
	    list($dpinf, $department)=$object->get_domain(VIS_TABLE_PREFIX.'domain.is_enabled=1', '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
	    
	    try {
			$response  = $remoteaccess_object->get_access_token($vis_domain, '24');
			if($response->error || $response->int_err_code){
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$response->error.$response->int_err_code.'");</script>';
			}
			else{
				$urls = $gotoassist_details['billing_url'];
				if(isset($data['vis_domain_filter'])){
					$goto_assist = $remoteaccess_object->get_assist_session($response->access_token, $operation['vis_domain'], $data, $urls, $page, $limit);
				}
				else{
					$goto_assist = $remoteaccess_object->get_assist_session($response->access_token, $vis_domain, '', $urls, $page, $limit);
				}
				if($goto_assist->error || $goto_assist->int_err_code){
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$goto_assist->error.$goto_assist->int_err_code.'");</script>';
				}else{
					$total_pages=$goto_assist->totalNumSessions;
					$total_session_page=ceil($total_pages/$limit);
				}
			}
		}
		
		catch (Exception $e) {
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGACCSSDND'].'");</script>';
			return false;
		}
		if((isset($operation['vis_filter_enable']) && $operation['vis_filter_enable']==1)){
			ob_start();
			include(VIS_PATH_TEMPLATE.'gotoassist_list.php');
			$assist_meeting_list = ob_get_clean();
			ob_end_flush();			
			$select='';
			$select .= "<div class=\"pull-right\">";
			$select .= "<select name=\"pageing\" id=\"paging\" class=\"form-control input-sm selectpicker pull-right paging v-middle\"  onchange=\"javascript:vis_apply_filter(this.value);\">";					  
			for($i=0;$i<$total_session_page;$i++)
				$select.='<option value="'.$i.'" '.(($page/$limit==$i)?'selected="selected"':'').'>'.($i+1).'</option>';
			$select .= "</select><div class=\"text-muted pull-right label_page\">".$vis_language['TXTPAGE'].":</div><script>$('.selectpicker').selectpicker();</script>";
			
			$select2='';
			$data_domain_live = ($department > 10) ? 'data-live-search="true"': '';
			$select2 .= "<select name=\"vis_domain\" id=\"vis_domain\" class=\"form-control selectpicker\" ".$data_domain_live." onchange=\"javascript:vis_change_domain(this.value);\">";
			for($j=0;$j<count($department);$j++){
				 if($vis_domain == $department[$j]['domain_id'])$chk = 'selected="selected"';
				 else $chk = '';
				
				if($vis_all_domain!=1){
					for($l=0;$l<count($gotoassist_setting);$l++){
						if($gotoassist_setting[$l]['domain_id'] == $department[$j]['domain_id']){ 
							$select2 .= '<option '.$chk.' value="'.$department[$j]['domain_id'].'">'.$department[$j]['domain_name'].'</option>'; 
						}
					}
				}else $select2 .= '<option '.$chk.' value="'.$department[$j]['domain_id'].'">'.$department[$j]['domain_name'].'</option>';
			 }
			$select2 .='</select><script>$(".selectpicker").selectpicker();</script>';
			
			echo json_encode( array('total_cnt' => $total_pages,'paging' => $select, 'domain'=>$select2, 'list'=> $assist_meeting_list));
		}else{
			if((isset($operation['vis_domain']) || isset($operation['vis_filter_enable'])) && isset($operation['vis_page']))
				include(VIS_PATH_TEMPLATE.'gotoassist_list.php');
			else
				include(VIS_PATH_TEMPLATE.'gotoassist.php');			
			return true;
		}
	}
	
	function new_gotoassist($operation){
		global $vis_language;
		$database=new class_database();
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		$object=new class_setting($database);
		
		$database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
        $staff_object=new class_staff($database);
        
        $filter1='integration_type=24 AND is_enabled=1 and domain_id=0';
		list($goto_info, $gotoassist_details)=$object->get_integration_setting($filter1, VIS_STAFF_ID, VIS_LOCATION_AREA, 'order by domain_id asc');
		if($gotoassist_details==-1){
			$filter1='integration_type=24 AND is_enabled=1';
			list($goto_info, $gotoassist_details)=$object->get_integration_setting($filter1, VIS_STAFF_ID, VIS_LOCATION_AREA, 'order by domain_id asc');
		}
		
        list($dpinf, $department)=$object->get_domain(VIS_TABLE_PREFIX.'domain.is_enabled=1', '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
		include(VIS_PATH_TEMPLATE.'gotoassist_new.php');
		return true;
	}
	
	function create_assist_session($operation) {
        global $vis_language;
        $database=new class_database();
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'remoteaccess.php');
		
		$remoteaccess_object=new class_remoteaccess($database);
		
        if(isset($operation['vis_action'])) $data=parse_form_array($operation['vis_action']);
        else $data=$operation;
        
        $response = $remoteaccess_object->get_access_token($data['vis_domain'], '24');
		if(isset($response->error) || isset($response->int_err_code)){
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$response->error.$response->int_err_code.'");</script>';
			return false;
		}
		else{
			$ch1 = curl_init(); 
			curl_setopt($ch1, CURLOPT_URL, "https://api.citrixonline.com/G2A/rest/v1/sessions");
			curl_setopt($ch1, CURLOPT_CUSTOMREQUEST, "POST");
			$data = array("sessionType"=>"screen_sharing");                                                                    
			$data_string = json_encode($data); 
			$headers = array ("Accept: application/json","Content-Type: application/json","Authorization: OAuth oauth_token=".$response->access_token);
			curl_setopt($ch1, CURLOPT_RETURNTRANSFER, true);
			curl_setopt($ch1, CURLOPT_POSTFIELDS, $data_string);
			curl_setopt($ch1, CURLOPT_HTTPHEADER, $headers);   
			$goto_company = curl_exec($ch1);
			curl_close($ch1);
			$goto_company = json_decode($goto_company);
			
			if(isset($goto_company->error) || isset($goto_company->int_err_code)){
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$goto_company->error.$goto_company->int_err_code.'");</script>';
				return true;
			}else{
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_area",{"vis_module":"remoteaccess", "vis_operation":"show_gotoassist_session", "vis_joinurl":"'.$goto_company->startScreenSharing->launchUrl.'", "vis_session_token":"'.$goto_company->startScreenSharing->sessionToken.'"});</script>';
				return true;
			}
		}
    }
    function show_gotoassist_session($operation){
		global $vis_language;
        $data=array('vis_joinurl'=>$operation['vis_joinurl'], 'vis_session_token'=>$operation['vis_session_token']);
        include(VIS_PATH_TEMPLATE.'gotoassist_session_details.php');
		return true;
	}
	
	function gotoassist_details($operation){
        global $vis_language;
        
        $database=new class_database();
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'remoteaccess.php');
		$remoteaccess_object=new class_remoteaccess($database);
		
        $spliter=(strstr($operation['vis_action'], '/'))?'/':',';
        $vis_domain = $operation['vis_chk_domain'];
		$vis_session = $operation['vis_assist_session_id'];
       
         if(isset($vis_domain) && $vis_domain!='' && is_numeric($vis_domain) && isset($vis_session) && $vis_session!='') {
			$filter='integration_type=23 AND domain_id='.$vis_domain;
			$access_details = $remoteaccess_object->get_access_token($vis_domain, '24');
			
			if($access_details->access_token){
				
				$goto_assist = $remoteaccess_object->get_assist_session_details($access_details->access_token, $vis_session, $vis_domain);
			
				if($goto_assist->screenSharing->status){
				
					include(VIS_PATH_TEMPLATE.'gotoassist_details.php');
					return true;
				}else{
					$this->error=$vis_language['MSGINFOMISS'];
					return false;
				}
			}
			else{
				$this->error=$vis_language['MSGINFOMISS'];
				return false;
			}
        }
        else {
            $this->error=$vis_language['MSGINFOMISS'];
            return false;
        }
    }
	
	function get_teamviewer_api_token($vis_domain) {
		$database=new class_database();
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		$object=new class_setting($database);
		list($dpinf, $domain)=$object->get_domain(VIS_TABLE_PREFIX.'domain.is_enabled=1', '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);	
		
		$intgration_filter='integration_type=25 AND is_enabled=1';
		list($gotomeeting_info, $teamviewer_details)=$object->get_integration_setting($intgration_filter, VIS_STAFF_ID, VIS_LOCATION_AREA, 'order by domain_id asc');	
		if($vis_domain == 0) {$vis_domain=$teamviewer_details[0]['domain_id'];}
		if($teamviewer_details==-1){
			$intgration_filter='integration_type=25 AND is_enabled=1 AND domain_id='.$vis_domain;
			list($gotomeeting_info, $teamviewer_details)=$object->get_integration_setting($intgration_filter, VIS_STAFF_ID, VIS_LOCATION_AREA, 'order by domain_id asc');
		}
		$remote_filter=' domain_id=0 and remoteapp_type=25 and staff_id='.VIS_STAFF_ID;
		$remote_filter1=' domain_id='.$vis_domain.' and remoteapp_type=25 and staff_id='.VIS_STAFF_ID;
		$database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
        $staff_object=new class_staff($database);		
	        $remotescreen_details=$staff_object->get_remotescreen_setting($remote_filter1, VIS_STAFF_ID, VIS_LOCATION_AREA);
      	if($remotescreen_details==-1){
			$remotescreen_details=$staff_object->get_remotescreen_setting($remote_filter, VIS_STAFF_ID, VIS_LOCATION_AREA); 
        }
  		return $remotescreen_details[0]['client_id'];
    }
	
	function get_teamviewer_meeting($api_token ,$vis_domain,$filter_array='') { 
		$intgration_filter='integration_type=25 AND domain_id='.$vis_domain;
		$database=new class_database();
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		$object=new class_setting($database);
		list($teamviewer_info, $teamviewer_details)=$object->get_integration_setting($intgration_filter, VIS_STAFF_ID, VIS_LOCATION_AREA, 'order by domain_id asc');
				
		$headers = array("POST ".$page." HTTP/1.0","Content-type: application/json; charset=\"utf-8\"","Cache-Control: no-cache","Pragma: no-cache","Authorization: Bearer  ".$api_token);	
		if($filter_array['vis_date_from']=='' && $filter_array['vis_date_to']==''){ 
			$url = "https://webapi.teamviewer.com/api/v1/meetings";
		}		
		else if($filter_array['vis_date_from']!='' && $filter_array['vis_date_to']=='')
		     {
				$from_date = $this->change_date_format($filter_array['vis_date_from']);
				$url = "https://webapi.teamviewer.com/api/v1/meetings?from_date=".$from_date;	
			 }
		else if($filter_array['vis_date_to']!='' && $filter_array['vis_date_from']=='')
			 {			
				$to_date = $this->change_date_format($filter_array['vis_date_to']);
				$url = "https://webapi.teamviewer.com/api/v1/meetings?to_date=".$to_date;	
			 }
		else
		{
			$from_date = $this->change_date_format($filter_array['vis_date_from']);	
			$to_date = $this->change_date_format($filter_array['vis_date_to']);
			$url = "https://webapi.teamviewer.com/api/v1/meetings?from_date=".$from_date."&to_date=".$to_date;		
		}	
		$ch1 = curl_init();
        curl_setopt($ch1, CURLOPT_URL,$url);
        curl_setopt($ch1, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch1, CURLOPT_TIMEOUT, 60);
        curl_setopt($ch1, CURLOPT_HTTPHEADER, $headers);     
        $teamviewer_meetings = curl_exec($ch1);
		curl_close($ch1);
		$teamviewer_meetings = json_decode($teamviewer_meetings,true);	
		return $teamviewer_meetings;    
    }
	
	function teamviewer_list($operation) {
		global $vis_language;
		$database=new class_database();
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		$object=new class_setting($database);
		
		if(!isset($operation['vis_domain'])){	
			$vis_all_domain=1;	
			$filter='integration_type=25 AND is_enabled=1 and domain_id=0';//if all domain selected in setting page
			list($gotomeeting_info, $teamviewer_details)=$object->get_integration_setting($filter, VIS_STAFF_ID, VIS_LOCATION_AREA,'order by domain_id asc');
			
			if($teamviewer_details==-1){  //if all domain is not selected in setting page
				$vis_all_domain=0;
				$filter='integration_type=25 AND is_enabled=1';
				list($gotomeeting_info, $teamviewer_details)=$object->get_integration_setting($filter, VIS_STAFF_ID, VIS_LOCATION_AREA,'order by domain_id asc');
			}
		}else{
			$filter='integration_type=25 AND domain_id='.$operation['vis_domain'];
			list($gotomeeting_info, $teamviewer_details)=$object->get_integration_setting($filter, VIS_STAFF_ID, VIS_LOCATION_AREA,'order by domain_id asc');
		}		
		$teamviewer_details=$teamviewer_details[0];
		$vis_domain = $teamviewer_details['domain_id'];
		
		$filter1='integration_type=25 AND is_enabled=1';
		list($gotomeeting_info, $teamviewer_domain)=$object->get_integration_setting($filter1, VIS_STAFF_ID, VIS_LOCATION_AREA,'order by domain_id desc');
		
		list($dpinf, $department)=$object->get_domain(VIS_TABLE_PREFIX.'domain.is_enabled=1', '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
		$domain_id = array();
		while($i<count($teamviewer_domain))
			{ $domain_id[] = $teamviewer_domain[$i]['domain_id'];$i++;}
		if($vis_domain==0){			
			$i=0;
			while($i<count($teamviewer_domain))
			{ 
				if($domain_id[$i] != 0)
				{	
					if($vis_domain==0)
						$vis_domain=$domain_id[$i];
				}
                                else
                                    $vis_domain=$department[0]['domain_id'];
				$i++;
			}
		}
		if(isset($operation['vis_domain']) && $operation['vis_domain']!='')
			$api_token = $this->get_teamviewer_api_token($operation['vis_domain']);
		else 	$api_token = $this->get_teamviewer_api_token($vis_domain);
		if(isset($operation['vis_date_from']) || isset($operation['vis_date_to']))
			$teamviewer_meetings = $this->get_teamviewer_meeting($api_token, $operation['vis_domain'],$operation);		
		else		
			$teamviewer_meetings = $this->get_teamviewer_meeting($api_token,$vis_domain);				
	    if(!isset($operation['vis_domain']))
	  	include(VIS_PATH_TEMPLATE.'teamviewer_meeting.php');
		else
			include(VIS_PATH_TEMPLATE.'teamviewer_meeting_list.php');	
		return true;
	}
	
	function get_teamviewer_sessions($api_token ,$vis_domain,$filter_array='') {
		$intgration_filter='integration_type=25 AND domain_id='.$vis_domain;
		$database=new class_database();
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		$object=new class_setting($database);
		list($teamviewer_info, $teamviewer_details)=$object->get_integration_setting($intgration_filter, VIS_STAFF_ID, VIS_LOCATION_AREA, 'order by domain_id asc');		
		if(isset($filter_array['vis_field_search']))
			$url = "https://webapi.teamviewer.com/api/v1/sessions?state=".$filter_array['vis_field_search'];
		else
			$url = "https://webapi.teamviewer.com/api/v1/sessions";
		$headers = array("POST ".$page." HTTP/1.0","Content-type: application/json; charset=\"utf-8\"","Cache-Control: no-cache","Pragma: no-cache","Content-length: ".strlen($data_json),
            "Authorization: Bearer  ".$api_token);
		$ch1 = curl_init();
        curl_setopt($ch1, CURLOPT_URL,$url);
        curl_setopt($ch1, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch1, CURLOPT_TIMEOUT, 60);
        curl_setopt($ch1, CURLOPT_HTTPHEADER, $headers);     
        $teamviewer_sessions = curl_exec($ch1);
		curl_close($ch1);
		$teamviewer_sessions = json_decode($teamviewer_sessions,true);	
		return $teamviewer_sessions;    
    }
	
	function teamviewer_session_list($operation) {	
		global $vis_language;
		$database=new class_database();
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		$object=new class_setting($database);
		if(!isset($operation['vis_domain'])){	
			$vis_all_domain=1;	
			$filter='integration_type=25 AND is_enabled=1 and domain_id=0';//if all domain selected in setting page
			list($gotomeeting_info, $teamviewer_details)=$object->get_integration_setting($filter, VIS_STAFF_ID, VIS_LOCATION_AREA,'order by domain_id asc');
			
			if($teamviewer_details==-1){  //if all domain is not selected in setting page
				$vis_all_domain=0;
				$filter='integration_type=25 AND is_enabled=1';
				list($gotomeeting_info, $teamviewer_details)=$object->get_integration_setting($filter, VIS_STAFF_ID, VIS_LOCATION_AREA,'order by domain_id asc');
			}
		}else{
			$filter='integration_type=25 AND domain_id='.$operation['vis_domain'];
			list($gotomeeting_info, $teamviewer_details)=$object->get_integration_setting($filter, VIS_STAFF_ID, VIS_LOCATION_AREA,'order by domain_id asc');
		}
		$teamviewer_details=$teamviewer_details[0];
		$vis_domain = $teamviewer_details['domain_id'];
		$filter1='integration_type=25 AND is_enabled=1';
		list($gotomeeting_info, $teamviewer_domain)=$object->get_integration_setting($filter1, VIS_STAFF_ID, VIS_LOCATION_AREA,'order by domain_id asc');
		list($dpinf, $department)=$object->get_domain(VIS_TABLE_PREFIX.'domain.is_enabled=1', '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
		$domain_id = array();
		while($i<count($teamviewer_domain))
			{ $domain_id[] = $teamviewer_domain[$i]['domain_id'];$i++;}
		if($vis_domain==0){			
			$i=0;
			while($i<count($teamviewer_domain))
			{ 
				if($domain_id[$i] != 0)
				{	
					if($vis_domain==0)
						$vis_domain=$domain_id[$i];
				}
                                else
                                    $vis_domain=$department[0]['domain_id'];
				$i++;
			}
		}
		if(!isset($operation['vis_domain'])) $api_token = $this->get_teamviewer_api_token($vis_domain);
		else $api_token = $this->get_teamviewer_api_token($operation['vis_domain']);
		if($operation['vis_field_search'])
			$teamviewer_sessions = $this->get_teamviewer_sessions($api_token,$vis_domain,$operation);	
		else
			$teamviewer_sessions = $this->get_teamviewer_sessions($api_token,$vis_domain);	
					
	    if(!isset($operation['vis_domain']))
	  		include(VIS_PATH_TEMPLATE.'teamviewer_session.php');
		else
			include(VIS_PATH_TEMPLATE.'teamviewer_session_list.php');	
		return true;
	}
	
	function get_teamviewer_meeting_details($api_token, $meeting_id, $vis_domain){
		$intgration_filter='integration_type=25 AND domain_id='.$vis_domain;
		$database=new class_database();
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		$object=new class_setting($database);
		list($gotomeeting_info, $teamviewer_details)=$object->get_integration_setting($intgration_filter, VIS_STAFF_ID, VIS_LOCATION_AREA, 'order by domain_id asc');
		$url = "https://webapi.teamviewer.com/api/v1/meetings/".$meeting_id;
		$headers = array("POST ".$page." HTTP/1.0","Content-type: application/json; charset=\"utf-8\"","Cache-Control: no-cache","Pragma: no-cache",
            "Authorization: Bearer  ".$api_token);
		$ch1 = curl_init();
        curl_setopt($ch1, CURLOPT_URL,$url);
        curl_setopt($ch1, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch1, CURLOPT_TIMEOUT, 60);
        curl_setopt($ch1, CURLOPT_HTTPHEADER, $headers);     
        $teamviewer_meetings = curl_exec($ch1);
		curl_close($ch1);
		$teamviewer_meetings = json_decode($teamviewer_meetings,true);	
		return $teamviewer_meetings;
	}
	
	function teamviewer_details($operation){
        global $vis_language;
        $spliter=(strstr($operation['vis_action'], '/'))?'/':',';
        $action=explode($spliter, $operation['vis_action']);
    	$api_token = $this->get_teamviewer_api_token($action[3]);
		if($api_token!='')
		{
			$teamviewer_meetings = $this->get_teamviewer_meeting_details($api_token, $action[4], $action[3]);		
			if($teamviewer_meetings['subject']!=''){
					include(VIS_PATH_TEMPLATE.'teamviewer_meeting_details.php');
					return true;
			}else{
					$this->error=$vis_language['MSGINFOMISS'];
					return false;
				}			
		}
		else
		{
			$this->error=$vis_language['MSGINFOMISS'];
			return false;
		}		
    }
	function get_teamviewer_session_details($api_token, $code, $vis_domain){
		$intgration_filter='integration_type=25 AND domain_id='.$vis_domain;
		$database=new class_database();
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		$object=new class_setting($database);
		list($gotomeeting_info, $teamviewer_details)=$object->get_integration_setting($intgration_filter, VIS_STAFF_ID, VIS_LOCATION_AREA, 'order by domain_id asc');
		$url = "https://webapi.teamviewer.com/api/v1/sessions/".$code;
		$headers = array("POST ".$page." HTTP/1.0","Content-type: application/json; charset=\"utf-8\"","Cache-Control: no-cache","Pragma: no-cache",
            "Authorization: Bearer  ".$api_token);
		$ch1 = curl_init();
        curl_setopt($ch1, CURLOPT_URL,$url);
        curl_setopt($ch1, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch1, CURLOPT_TIMEOUT, 60);
        curl_setopt($ch1, CURLOPT_HTTPHEADER, $headers);     
        $teamviewer_sessions = curl_exec($ch1);
		curl_close($ch1);
		$teamviewer_sessions = json_decode($teamviewer_sessions,true);	
		return $teamviewer_sessions;
	}
	
	function teamviewer_session_details($operation){
        global $vis_language;
        $spliter=(strstr($operation['vis_action'], '/'))?'/':',';
        $action=explode($spliter, $operation['vis_action']);
    	$api_token = $this->get_teamviewer_api_token($action[3]);		
		if($api_token!='')
		{
			$teamviewer_sessions = $this->get_teamviewer_session_details($api_token, $action[4], $action[3]);		
			if($teamviewer_sessions['code']!=''){
					include(VIS_PATH_TEMPLATE.'teamviewer_session_details.php');
					return true;
				}else{
					$this->error=$vis_language['MSGINFOMISS'];
					return false;
				}			
		}
		else
		{
			$this->error=$vis_language['MSGINFOMISS'];
			return false;
		}		
    }
	
	function new_meeting($operation) {
		global $vis_language;
		$database=new class_database();
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		$object=new class_setting($database);
		
		$database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
        $staff_object=new class_staff($database);
        
        $filter1='integration_type=25 AND is_enabled=1';
		list($goto_info, $teamviewer_details)=$object->get_integration_setting($filter1, VIS_STAFF_ID, VIS_LOCATION_AREA, 'order by domain_id asc');
		
        list($dpinf, $department)=$object->get_domain(VIS_TABLE_PREFIX.'domain.is_enabled=1', '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
		include(VIS_PATH_TEMPLATE.'teamviewer_newmeeting.php');
		return true;
	}
	
	function group_list($operation)
	{
		global $vis_language;
		if(isset($operation['vis_action'])) $data=parse_form_array($operation['vis_action']);
        else $data=$operation;			
        $api_token = $this->get_teamviewer_api_token($data['vis_domain']);
		$url = "https://webapi.teamviewer.com/api/v1/groups";
		$headers = array("POST ".$page." HTTP/1.0","Content-type: application/json; charset=\"utf-8\"","Cache-Control: no-cache","Pragma: no-cache","Authorization: Bearer  ".$api_token);
		$ch = curl_init(); 
		curl_setopt_array ($ch, array ( CURLOPT_URL => $url,CURLOPT_RETURNTRANSFER => 1, CURLOPT_TIMEOUT => 60,CURLOPT_HTTPHEADER => $headers));
        $group_list = curl_exec($ch);
		curl_close($ch);
		$group_list = json_decode($group_list,true);
		if($group_list['error'] || $group_list['error_code']){
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$results['error'].'");</script>';
			return false;
		}
		if(count($group_list['groups']) == 0)
		{			
			$data_json = '{"name" : "Vision Helpdesk"}';			
			$ch1 = curl_init(); 
			curl_setopt_array ($ch1, array ( CURLOPT_URL => $url,CURLOPT_RETURNTRANSFER => 1, CURLOPT_TIMEOUT => 60,CURLOPT_HTTPHEADER => $headers,	CURLOPT_POST => 1,CURLOPT_POSTFIELDS => $data_json));
	        $results = curl_exec($ch1);
			$results = json_decode($results,true);
			curl_close($ch1);
			if($results['error'] || $results['error_code']){
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$results['error'].'");</script>';
				return false;
			}
			$ch = curl_init(); 
			curl_setopt_array ($ch, array ( CURLOPT_URL => $url,CURLOPT_RETURNTRANSFER => 1, CURLOPT_TIMEOUT => 60,CURLOPT_HTTPHEADER => $headers));
       		$group_list = curl_exec($ch);
			curl_close($ch);
			$group_list = json_decode($group_list,true);
			if($group_list['error'] || $group_list['error_code']){
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$results['error'].'");</script>';
				return false;
			}
		}
		return $group_list;
	}
	
	function new_session($operation) {
		global $vis_language;
		$database=new class_database();
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		$object=new class_setting($database);
		$database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
        $staff_object=new class_staff($database);
        $filter1='integration_type=25 AND is_enabled=1';
		list($goto_info, $teamviewer_details)=$object->get_integration_setting($filter1, VIS_STAFF_ID, VIS_LOCATION_AREA, 'order by domain_id asc');
		$group_list = $this->group_list($operation);
        list($dpinf, $department)=$object->get_domain(VIS_TABLE_PREFIX.'domain.is_enabled=1', '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
		include(VIS_PATH_TEMPLATE.'teamviewer_newsession.php');
		return true;
	}
	function change_date_format($date) {
		$datetime = new DateTime($date);
		$date = $datetime->format('Y-m-d');
		$time = $datetime->format('H:i:s');
		$dateformat = $date.'T'.$time.'Z';
		return $dateformat;
	}
	
	function create_teamviewer_meeting($operation) {
		global $vis_language;
		if(isset($operation['vis_action'])) $data=parse_form_array($operation['vis_action']);
        else $data=$operation;		
                $api_token = $this->get_teamviewer_api_token($data['vis_domain']);
		$data_json =  '{"subject":"'.$data['vis_subject'].'","start":"'.$this->change_date_format($data['vis_startdate']).'","end":"' .$this->change_date_format($data['vis_enddate']).'"}';
		$url = "https://webapi.teamviewer.com/api/v1/meetings";
		$headers = array("POST ".$page." HTTP/1.0","Content-type: application/json; charset=\"utf-8\"","Cache-Control: no-cache","Pragma: no-cache","Content-length: ".strlen($data_json),
            "Authorization: Bearer  ".$api_token);
		$ch = curl_init(); 
		curl_setopt_array ($ch, array ( CURLOPT_URL => $url,CURLOPT_RETURNTRANSFER => 1, CURLOPT_TIMEOUT => 60,CURLOPT_HTTPHEADER => $headers,CURLOPT_POST => 1,CURLOPT_POSTFIELDS => $data_json));
        $results = curl_exec($ch);
		curl_close($ch);
		$results = json_decode($results,true);
		if($results['error'] || $results['error_code']){
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$results['error'].'");</script>';
			return false;
		}else{
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'");$("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTTEAMVIEWER'].'",{"vis_module":"remoteaccess", "vis_operation":"teamviewer_list"}); </script>';
				return true;
		}
		return true;
	}
	
	function get_teamviewer_meeting_delete($operation) {
        global $vis_language;
        $message_info['vis_form_title']=$vis_language['TXTDELETEGOTOMEETING'];
        $message_info['vis_message']=$vis_language['MSGSURE'];
        $message_info['vis_event']="$('#vis_global_msg_div').visExecution('load_operations', {'vis_module':'remoteaccess', 'vis_operation':'delete_teamviewer_meeting', 'vis_domain':'".$operation['vis_domain']."', 'vis_meeting_id':'".$operation['vis_meeting_id']."'})";
        include(VIS_PATH_TEMPLATE.'confirm_delete.php');
        return true;
    }
	
	function delete_teamviewer_meeting($operation){
		global $vis_language;
		$api_token = $this->get_teamviewer_api_token($operation['vis_domain']);
		$intgration_filter='integration_type=25 AND domain_id='.$operation['vis_domain'];
		$database=new class_database();
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		$object=new class_setting($database);
		list($teamviewer_info, $teamviewer_details)=$object->get_integration_setting($intgration_filter, VIS_STAFF_ID, VIS_LOCATION_AREA, 'order by domain_id asc');
		$url = "https://webapi.teamviewer.com/api/v1/meetings/".$operation['vis_meeting_id'];
		$ch1 = curl_init();
		curl_setopt($ch1, CURLOPT_URL, $url);
		$headers = array("POST ".$page." HTTP/1.0","Content-type: application/json; charset=\"utf-8\"","Cache-Control: no-cache","Pragma: no-cache","Authorization: Bearer  ".$api_token);
		curl_setopt($ch1, CURLOPT_HTTPHEADER, $headers);
		curl_setopt($ch1, CURLOPT_CUSTOMREQUEST, "DELETE");
		curl_setopt($ch1, CURLOPT_RETURNTRANSFER, true);   
		$results = curl_exec($ch1);
		curl_close($ch1);
		$results = json_decode($results,true);
		if($results['error'] || $results['error_code']){
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$results['error'].'");</script>';
			return false;
		}else{
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'");$("#vis_teamviewer_meeting_list").visExecution("load_module","'.$vis_language['TXTTEAMVIEWER'].'",{"vis_module":"remoteaccess", "vis_operation":"teamviewer_list","vis_domain":"'.$operation['vis_domain'].'"}); </script>';
				return true;
		}
		return true;
	}
	
	function create_session($operation) {
		global $vis_language;
		if(isset($operation['vis_action'])) $data=parse_form_array($operation['vis_action']);
        else $data=$operation;		
		$api_token = $this->get_teamviewer_api_token($data['vis_domain']);	
		$data_json =  '{"groupid":"'.$data['vis_groupid'].'"}';
		$url = "https://webapi.teamviewer.com/api/v1/sessions";
		$headers = array("POST ".$page." HTTP/1.0","Content-type: application/json; charset=\"utf-8\"","Cache-Control: no-cache","Pragma: no-cache","Content-length: ".strlen($data_json),
            "Authorization: Bearer  ".$api_token);
		$ch = curl_init(); 
		curl_setopt_array ($ch, array ( CURLOPT_URL => $url,CURLOPT_RETURNTRANSFER => 1, CURLOPT_TIMEOUT => 60,CURLOPT_HTTPHEADER => $headers,CURLOPT_POST => 1,CURLOPT_POSTFIELDS => $data_json,));
        $response = curl_exec($ch);
		$response = json_decode($response,true);
		curl_close($ch);
		if($response['error'] || $response['error_code']){
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$response['error'].'");</script>';
			return false;
		}else{
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'");$("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTTEAMVIEWER'].'",{"vis_module":"remoteaccess", "vis_operation":"teamviewer_session_list"}); </script>';
				return true;
		}
		return true;
	}
	
	function webex($operation){
		global $vis_language;
		$database=new class_database();
		
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		$object=new class_setting($database);
		
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'remoteaccess.php');
		$remoteaccess_object=new class_remoteaccess($database);
		
		if(!isset($operation['vis_domain'])){
			$vis_all_domain=1;
			$filter='integration_type=26 AND is_enabled=1 and domain_id=0';//if all domain selected in setting page
			list($webex_info, $webex_details)=$object->get_integration_setting($filter, VIS_STAFF_ID, VIS_LOCATION_AREA,' order by domain_id asc');
			if($webex_details==-1){  //if all domain is not selected in setting page
				$vis_all_domain=0;
				$filter='integration_type=26 AND is_enabled=1';
				list($webex_info, $webex_details)=$object->get_integration_setting($filter, VIS_STAFF_ID, VIS_LOCATION_AREA,' order by domain_id asc');
			}
		}else{
			$filter='integration_type=26 AND domain_id='.$operation['vis_domain'];
			list($webex_info, $webex_details)=$object->get_integration_setting($filter, VIS_STAFF_ID, VIS_LOCATION_AREA,' order by domain_id asc');
		}
		
		$limit = SECURITY_DATA_PER_PAGE;
		$page = (isset($operation['vis_page']) && is_numeric($operation['vis_page'])) ? $limit*$operation['vis_page']:0;
		
		
   
		$webex_details=$webex_details[0];
		$vis_domain = $webex_details['domain_id'];
		
		$filter1='integration_type=26 AND is_enabled=1';
		list($goto_info, $webex_setting)=$object->get_integration_setting($filter1, VIS_STAFF_ID, VIS_LOCATION_AREA, 'order by domain_id asc');
	    list($dpinf, $department)=$object->get_domain(VIS_TABLE_PREFIX.'domain.is_enabled=1', '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
	    if($vis_domain==0){
			$vis_domain=$department[0]['domain_id'];
		}
	    try {
			$webex_meeting_listing = $remoteaccess_object->get_webex_meeting($vis_domain);
			
			$total_meeting=count($webex_meeting_listing->bodyContent);
			$total_page=ceil($total_meeting/$limit);
			
		}
		catch (Exception $e) {
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGACCSSDND'].'");</script>';
			return false;
		}
		
		if(isset($operation['vis_domain']))
			include(VIS_PATH_TEMPLATE.'webex_list.php');
		else
			include(VIS_PATH_TEMPLATE.'webex.php');			
		return true;
		
	}
	
	function new_webex_meeting($operation){
		global $vis_language;
		$database=new class_database();
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		$object=new class_setting($database);
		
		$database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
        $staff_object=new class_staff($database);
        
        $filter1='integration_type=26 AND is_enabled=1 and domain_id=0';
		list($webex_info, $webex_details)=$object->get_integration_setting($filter1, VIS_STAFF_ID, VIS_LOCATION_AREA, 'order by domain_id asc');
		if($webex_details==-1){
			$filter1='integration_type=26 AND is_enabled=1';
			list($webex_info, $webex_details)=$object->get_integration_setting($filter1, VIS_STAFF_ID, VIS_LOCATION_AREA, 'order by domain_id asc');
		}
		
        list($dpinf, $department)=$object->get_domain(VIS_TABLE_PREFIX.'domain.is_enabled=1', '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
		include(VIS_PATH_TEMPLATE.'webex_new.php');
		return true;
	}
	
	function create_webex_meeting($operation) {
        global $vis_language;
        $database=new class_database();
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'remoteaccess.php');
		
		$remoteaccess_object=new class_remoteaccess($database);
		
        if(isset($operation['vis_action'])) $data=parse_form_array($operation['vis_action']);
        else $data=$operation;
       
        if($data['vis_title']=='' || $data['vis_startdate']=='' || $data['vis_duration']=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'");</script>';
            return false;
        }
        if(!is_numeric($data['vis_duration']) || $data['vis_duration']>20) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'");</script>';
            return false;
        }
      
		if($data['vis_domain']=='' || !isset($data['vis_domain'])){
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
			return false;
		}
		else{
			
			$create_webex_meeting = $remoteaccess_object->create_webex_meeting($data);
			$pos = strpos($create_webex_meeting, "SUCCESS");
			if($pos === false){
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'");</script>';
				return false;
			}else{
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'");$("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTGOTOWEBEX'].'",{"vis_module":"remoteaccess", "vis_operation":"webex"}); </script>';
				return true;
			}
		}
    }
    
	function webex_details($operation){
        global $vis_language;
        
        $database=new class_database();
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'remoteaccess.php');
		$remoteaccess_object=new class_remoteaccess($database);
		
        $spliter=(strstr($operation['vis_action'], '/'))?'/':',';
        $action=explode($spliter, $operation['vis_action']);
       
         if(isset($action[3]) && $action[3]!='' && is_numeric($action[3]) && isset($action[4]) && $action[4]!='') {
			
			$webex_meeting_details = $remoteaccess_object->webex_meeting_details($action[3], $action[4]);
			if(count($webex_meeting_details)>0){
				include(VIS_PATH_TEMPLATE.'webex_details.php');
				return true;
			}
			else{
				$this->error=$vis_language['MSGINFOMISS'];
				return false;
			}
        }
        else {
            $this->error=$vis_language['MSGINFOMISS'];
            return false;
        }
    }
    
    function get_webex_delete($operation) {
        global $vis_language;
        $message_info['vis_form_title']=$vis_language['TXTDELETEWEBEX'];
        $message_info['vis_message']=$vis_language['MSGSURE'];
        $message_info['vis_event']="$('#vis_global_msg_div').visExecution('load_operations', {'vis_module':'remoteaccess', 'vis_operation':'delete_webex_meeting', 'vis_domain':'".$operation['vis_domain']."', 'vis_meeting_id':'".$operation['vis_meeting_id']."'})";
        include(VIS_PATH_TEMPLATE.'confirm_delete.php');
        return true;
    }
	
	function delete_webex_meeting($operation){
		global $vis_language;
		$database=new class_database();
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'remoteaccess.php');
		$remoteaccess_object=new class_remoteaccess($database);
		
		$delete_webex_meeting = $remoteaccess_object->delete_webex_meeting($operation['vis_domain'], $operation['vis_meeting_id']);
		if($delete_webex_meeting){	
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_webex_list").visExecution("load_area",{"vis_module":"remoteaccess", "vis_operation":"webex", "vis_page":0 ,"vis_domain":'.$operation['vis_domain'].'}); </script>';
		}
		return true;
	}
	
}
?>
